/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.serial.Serial;

public class Visual64ButtonShieldTester
extends PApplet {
    Serial port;
    dotmat[] dotmatrix = new dotmat[65];
    int DOTSIZE = 55;
    int DOTSPACE = 5;
    int bkgcolor = -6697729;
    int DotOnColor = -16711936;
    int DotOFFColor = 202;

    public void setup() {
        this.size(600, 600, "processing.opengl.PGraphicsOpenGL");
        this.lights();
        this.background(this.bkgcolor);
        this.port = new Serial((PApplet)this, Serial.list()[0], 115200);
        int n = this.DOTSPACE * 2 + this.DOTSIZE;
        int n2 = 1;
        while (n2 < 9) {
            int n3 = 0;
            while (n3 < 8) {
                this.dotmatrix[n2 + n3 * 8] = new dotmat(this.DOTSIZE, n * n2, n + n * n3);
                ++n3;
            }
            ++n2;
        }
        this.refreshdisplay();
    }

    public void draw() {
        this.lights();
        this.camera(320.0f, 700.0f, 525.0f, 300.0f, 390.0f, 50.0f, 0.0f, 1.0f, 0.0f);
        this.refreshdisplay();
        if (this.port.available() > 0) {
            int n;
            int n2 = this.port.read();
            if (n2 > -1) {
                this.TestPress(n2);
            }
            if ((n = this.port.read()) > -1) {
                this.TestPress(n);
            }
        }
    }

    public void TestPress(int n) {
        if (n > 127) {
            this.dotmatrix[n -= 128].pressed = true;
            this.refreshdisplay();
        } else {
            this.dotmatrix[n].pressed = false;
            this.refreshdisplay();
        }
    }

    public void refreshdisplay() {
        this.background(this.bkgcolor);
        int n = 1;
        while (n < 65) {
            this.dotmatrix[n].display();
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#c0c0c0", "Visual64ButtonShieldTester"});
    }

    class dotmat {
        int bxpos;
        int bypos;
        int DotSiz;
        int tallness;
        int talltrans;
        boolean pressed = false;

        dotmat(int n, int n2, int n3) {
            this.bxpos = n2;
            this.bypos = n3;
            this.DotSiz = n;
        }

        public void display() {
            if (this.pressed) {
                this.tallness = 50;
                this.talltrans = 0;
                Visual64ButtonShieldTester.this.fill(Visual64ButtonShieldTester.this.DotOnColor);
            } else {
                Visual64ButtonShieldTester.this.fill(Visual64ButtonShieldTester.this.DotOFFColor);
                this.tallness = 100;
                this.talltrans = 25;
            }
            Visual64ButtonShieldTester.this.stroke(0);
            Visual64ButtonShieldTester.this.strokeWeight(1.0f);
            Visual64ButtonShieldTester.this.pushMatrix();
            Visual64ButtonShieldTester.this.shininess(1.0f);
            Visual64ButtonShieldTester.this.translate(this.bxpos, this.bypos, 0.0f);
            Visual64ButtonShieldTester.this.box(this.DotSiz, this.DotSiz, this.tallness);
            Visual64ButtonShieldTester.this.popMatrix();
        }
    }
}

