//  *****************************************************************************************************************
//  *                                                                                                               *
//  *                                         SpikenzieLabs.com                                                     *
//  *                                                                                                               *
//  *                                Visual Tester for 64 Button Shield                                             *
//  *                                                                                                               *
//  *                                                                                                               *
//  *****************************************************************************************************************
//
// BY: MARK DEMERS 
// June. 2009
// 
// Note: This software is provided as is with no guaranties what so ever. 


import processing.opengl.*;
import processing.serial.*;
Serial port;  

dotmat  dotmatrix[] = new dotmat[65];

int DOTSIZE = 55;
int DOTSPACE = 5;

color bkgcolor = #99CCFF;
color DotOnColor = #00FF00;
color DotOFFColor = 202;

void setup() 
{
  size(600, 600, OPENGL);
  lights();
  background(bkgcolor);

  port = new Serial(this,Serial.list()[0], 115200); // /dev/tty.usbserial-A9007Oqe

  int spacer = DOTSPACE*2+DOTSIZE;

  for(int i = 1; i< 9; i++)
  {

    for(int y = 0; y< 8; y++)
    {
      dotmatrix[i+(y*8)] = new dotmat(DOTSIZE,spacer*i,spacer+(spacer*y));
    }
  }


  refreshdisplay();

}

void draw()
{
  lights();
  camera(300+20, 700, 525, // eyeX, eyeY, eyeZ was 525
  300, 390, 50, // centerX, centerY, centerZ
  0.0, 1.0, 0.0); // upX, upY, upZ
  refreshdisplay();


  if(port.available() > 0)
  {
    int Byte1 = port.read();
    if(Byte1 > -1)
    {
      TestPress(Byte1);
    }
    int Byte2 = port.read();
    if(Byte2 > -1)
    {
      TestPress(Byte2);
    }
  }

}

void TestPress(int RxData)
{
  if(RxData > 127)
  {
    // ---------------------------------------- ON   
    RxData = RxData -128;
    dotmatrix[RxData].pressed = true;
    refreshdisplay();

  }
  else
  {
    // ---------------------------------------- OFF    
    dotmatrix[RxData].pressed = false;
    refreshdisplay();
  }
}

void refreshdisplay()
{
  background(bkgcolor);
  for(int i = 1; i< 65; i++) dotmatrix[i].display();
}


//--------------------------------------------------------------------------------------

class dotmat 
{
  int bxpos; 
  int bypos;
  int DotSiz; 
//  float time = millis();
  int tallness;
  int talltrans;

  boolean pressed = false;

  // Dot size, Dot X, Dot Y, 
  dotmat(int dotsize, int ixp, int iyp) {
    bxpos = ixp;
    bypos = iyp;
    DotSiz = dotsize;

  }

  void display() 
  {
    if(pressed == true)
    {
      tallness = 50;
      talltrans = 0;
      fill(DotOnColor);

    }
    else
    {
      fill(DotOFFColor);
      tallness = 100;
      talltrans =25;
    }
    
    stroke(0);
    strokeWeight(1);   // Default

    // -------------- 3D
    pushMatrix();
    //  smooth();
    // specular(128.0, 100.0,0.0);
    shininess(1.0);
    translate(bxpos,bypos, 0);
    // rotateY(radians(10));

    box(DotSiz, DotSiz, tallness);
    popMatrix();
  }

}  

// ----------------


