/*
 * Decompiled with CFR 0.152.
 */
package processing.serial;

import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import processing.core.PApplet;

public class Serial
implements SerialPortEventListener {
    PApplet parent;
    Method serialEventMethod;
    public SerialPort port;
    public int rate;
    public int parity;
    public int databits;
    public int stopbits;
    public InputStream input;
    public OutputStream output;
    byte[] buffer = new byte[32768];
    int bufferIndex;
    int bufferLast;
    int bufferSize = 1;
    boolean bufferUntil;
    int bufferUntilByte;
    static String dname = "COM1";
    static int drate = 9600;
    static char dparity = (char)78;
    static int ddatabits = 8;
    static float dstopbits = 1.0f;

    public void setProperties(Properties properties) {
        dname = properties.getProperty("serial.port", dname);
        drate = Integer.parseInt(properties.getProperty("serial.rate", "9600"));
        dparity = properties.getProperty("serial.parity", "N").charAt(0);
        ddatabits = Integer.parseInt(properties.getProperty("serial.databits", "8"));
        dstopbits = new Float(properties.getProperty("serial.stopbits", "1")).floatValue();
    }

    public Serial(PApplet pApplet) {
        this(pApplet, dname, drate, dparity, ddatabits, dstopbits);
    }

    public Serial(PApplet pApplet, int n) {
        this(pApplet, dname, n, dparity, ddatabits, dstopbits);
    }

    public Serial(PApplet pApplet, String string, int n) {
        this(pApplet, string, n, dparity, ddatabits, dstopbits);
    }

    public Serial(PApplet pApplet, String string) {
        this(pApplet, string, drate, dparity, ddatabits, dstopbits);
    }

    public Serial(PApplet pApplet, String string, int n, char c, int n2, float f) {
        this.parent = pApplet;
        this.rate = n;
        this.parity = 0;
        if (c == 'E') {
            this.parity = 2;
        }
        if (c == 'O') {
            this.parity = 1;
        }
        this.databits = n2;
        this.stopbits = 1;
        if (f == 1.5f) {
            this.stopbits = 3;
        }
        if (f == 2.0f) {
            this.stopbits = 2;
        }
        try {
            Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
            while (enumeration.hasMoreElements()) {
                CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
                if (commPortIdentifier.getPortType() != 1 || !commPortIdentifier.getName().equals(string)) continue;
                this.port = (SerialPort)commPortIdentifier.open("serial madness", 2000);
                this.input = this.port.getInputStream();
                this.output = this.port.getOutputStream();
                this.port.setSerialPortParams(this.rate, this.databits, this.stopbits, this.parity);
                this.port.addEventListener((SerialPortEventListener)this);
                this.port.notifyOnDataAvailable(true);
            }
        }
        catch (Exception exception) {
            Serial.errorMessage("<init>", exception);
            this.port = null;
            this.input = null;
            this.output = null;
        }
        pApplet.registerDispose((Object)this);
        try {
            this.serialEventMethod = pApplet.getClass().getMethod("serialEvent", Serial.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        this.dispose();
    }

    public void dispose() {
        try {
            if (this.input != null) {
                this.input.close();
            }
            if (this.output != null) {
                this.output.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.input = null;
        this.output = null;
        try {
            if (this.port != null) {
                this.port.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.port = null;
    }

    public void setDTR(boolean bl) {
        this.port.setDTR(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized void serialEvent(SerialPortEvent serialPortEvent) {
        if (serialPortEvent.getEventType() != 1) return;
        try {
            while (this.input.available() > 0) {
                byte[] byArray = this.buffer;
                // MONITORENTER : this.buffer
                if (this.bufferLast == this.buffer.length) {
                    byte[] byArray2 = new byte[this.bufferLast << 1];
                    System.arraycopy(this.buffer, 0, byArray2, 0, this.bufferLast);
                    this.buffer = byArray2;
                }
                this.buffer[this.bufferLast++] = (byte)this.input.read();
                if (this.serialEventMethod != null && (this.bufferUntil && this.buffer[this.bufferLast - 1] == this.bufferUntilByte || !this.bufferUntil && this.bufferLast - this.bufferIndex >= this.bufferSize)) {
                    try {
                        this.serialEventMethod.invoke((Object)this.parent, this);
                    }
                    catch (Exception exception) {
                        String string = "error, disabling serialEvent() for " + this.port;
                        System.err.println(string);
                        exception.printStackTrace();
                        this.serialEventMethod = null;
                    }
                }
                // MONITOREXIT : byArray
            }
            return;
        }
        catch (IOException iOException) {
            Serial.errorMessage("serialEvent", iOException);
        }
    }

    public void buffer(int n) {
        this.bufferUntil = false;
        this.bufferSize = n;
    }

    public void bufferUntil(int n) {
        this.bufferUntil = true;
        this.bufferUntilByte = n;
    }

    public int available() {
        return this.bufferLast - this.bufferIndex;
    }

    public void clear() {
        this.bufferLast = 0;
        this.bufferIndex = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() {
        if (this.bufferIndex == this.bufferLast) {
            return -1;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int n = this.buffer[this.bufferIndex++] & 0xFF;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int last() {
        if (this.bufferIndex == this.bufferLast) {
            return -1;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            byte by = this.buffer[this.bufferLast - 1];
            this.bufferIndex = 0;
            this.bufferLast = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return by;
        }
    }

    public char readChar() {
        if (this.bufferIndex == this.bufferLast) {
            return '\uffff';
        }
        return (char)this.read();
    }

    public char lastChar() {
        if (this.bufferIndex == this.bufferLast) {
            return '\uffff';
        }
        return (char)this.last();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes() {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int n = this.bufferLast - this.bufferIndex;
            byte[] byArray2 = new byte[n];
            System.arraycopy(this.buffer, this.bufferIndex, byArray2, 0, n);
            this.bufferIndex = 0;
            this.bufferLast = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return byArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytes(byte[] byArray) {
        if (this.bufferIndex == this.bufferLast) {
            return 0;
        }
        byte[] byArray2 = this.buffer;
        synchronized (this.buffer) {
            int n = this.bufferLast - this.bufferIndex;
            if (n > byArray.length) {
                n = byArray.length;
            }
            System.arraycopy(this.buffer, this.bufferIndex, byArray, 0, n);
            this.bufferIndex += n;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytesUntil(int n) {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        byte by = (byte)n;
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int n2;
            int n3 = -1;
            for (n2 = this.bufferIndex; n2 < this.bufferLast; ++n2) {
                if (this.buffer[n2] != by) continue;
                n3 = n2;
                break;
            }
            if (n3 == -1) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            n2 = n3 - this.bufferIndex + 1;
            byte[] byArray2 = new byte[n2];
            System.arraycopy(this.buffer, this.bufferIndex, byArray2, 0, n2);
            this.bufferIndex += n2;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return byArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytesUntil(int n, byte[] byArray) {
        if (this.bufferIndex == this.bufferLast) {
            return 0;
        }
        byte by = (byte)n;
        byte[] byArray2 = this.buffer;
        synchronized (this.buffer) {
            int n2;
            int n3 = -1;
            for (n2 = this.bufferIndex; n2 < this.bufferLast; ++n2) {
                if (this.buffer[n2] != by) continue;
                n3 = n2;
                break;
            }
            if (n3 == -1) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return 0;
            }
            n2 = n3 - this.bufferIndex + 1;
            if (n2 > byArray.length) {
                System.err.println("readBytesUntil() byte buffer is too small for the " + n2 + " bytes up to and including char " + n);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return -1;
            }
            System.arraycopy(this.buffer, this.bufferIndex, byArray, 0, n2);
            this.bufferIndex += n2;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return n2;
        }
    }

    public String readString() {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        return new String(this.readBytes());
    }

    public String readStringUntil(int n) {
        byte[] byArray = this.readBytesUntil(n);
        if (byArray == null) {
            return null;
        }
        return new String(byArray);
    }

    public void write(int n) {
        try {
            this.output.write(n & 0xFF);
            this.output.flush();
        }
        catch (Exception exception) {
            Serial.errorMessage("write", exception);
        }
    }

    public void write(byte[] byArray) {
        try {
            this.output.write(byArray);
            this.output.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void write(String string) {
        this.write(string.getBytes());
    }

    public static String[] list() {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        try {
            objectArray = CommPortIdentifier.getPortIdentifiers();
            while (objectArray.hasMoreElements()) {
                CommPortIdentifier commPortIdentifier = (CommPortIdentifier)objectArray.nextElement();
                if (commPortIdentifier.getPortType() != 1) continue;
                String string = commPortIdentifier.getName();
                vector.addElement(string);
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Serial.errorMessage("ports", unsatisfiedLinkError);
        }
        catch (Exception exception) {
            Serial.errorMessage("ports", exception);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static void errorMessage(String string, Throwable throwable) {
        throwable.printStackTrace();
        throw new RuntimeException("Error inside Serial." + string + "()");
    }
}

