/*
 * Decompiled with CFR 0.152.
 */
package themidibus;

import java.lang.reflect.Method;
import java.util.Formatter;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;
import processing.core.PApplet;
import themidibus.MidiListener;
import themidibus.RawMidiListener;
import themidibus.SimpleMidiListener;
import themidibus.StandardMidiListener;

public class MidiBus {
    String bus_name;
    Vector<MidiDevice> in_devices;
    Vector<Receiver> in_receivers;
    Vector<Transmitter> in_transmitters;
    Vector<MidiDevice> out_devices;
    Vector<Receiver> out_receivers;
    Vector<MidiListener> listeners;
    Vector<RawMidiListener> raw_listeners;
    Vector<SimpleMidiListener> simple_listeners;
    Vector<StandardMidiListener> standard_listeners;
    PApplet parent;
    Method eventMethod_noteOn;
    Method eventMethod_noteOff;
    Method eventMethod_controllerChange;
    Method eventMethod_rawMidi;
    Method eventMethod_midiMessage;
    Method eventMethod_noteOn_withBusName;
    Method eventMethod_noteOff_withBusName;
    Method eventMethod_controllerChange_withBusName;
    Method eventMethod_rawMidi_withBusName;
    Method eventMethod_midiMessage_withBusName;

    public MidiBus(PApplet pApplet) {
        this.init(pApplet, -1, -1);
    }

    public MidiBus(PApplet pApplet, int n, int n2) {
        this.init(pApplet, n, n2);
    }

    public MidiBus(PApplet pApplet, int n, int n2, String string) {
        this.init(pApplet, n, n2, string);
    }

    public MidiBus(PApplet pApplet, String string) {
        this.init(pApplet, -1, -1, string);
    }

    public MidiBus(PApplet pApplet, String string, String string2) {
        this.init(pApplet, this.inputDeviceNameToNumber(string), this.outputDeviceNameToNumber(string2));
    }

    public MidiBus(PApplet pApplet, String string, String string2, String string3) {
        this.init(pApplet, this.inputDeviceNameToNumber(string), this.outputDeviceNameToNumber(string2), string3);
    }

    private void init(PApplet pApplet, int n, int n2) {
        String string = new Formatter().format("%08d", System.currentTimeMillis() % 100000000L).toString();
        this.init(pApplet, n, n2, "MidiBus" + string);
    }

    private void init(PApplet pApplet, int n, int n2, String string) {
        this.parent = pApplet;
        pApplet.registerDispose((Object)this);
        try {
            this.eventMethod_noteOn = pApplet.getClass().getMethod("noteOn", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.eventMethod_noteOff = pApplet.getClass().getMethod("noteOff", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.eventMethod_controllerChange = pApplet.getClass().getMethod("controllerChange", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.eventMethod_rawMidi = pApplet.getClass().getMethod("rawMidi", byte[].class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.eventMethod_midiMessage = pApplet.getClass().getMethod("midiMessage", MidiMessage.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.eventMethod_noteOn_withBusName = pApplet.getClass().getMethod("noteOn", Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.eventMethod_noteOff_withBusName = pApplet.getClass().getMethod("noteOff", Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.eventMethod_controllerChange_withBusName = pApplet.getClass().getMethod("controllerChange", Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.eventMethod_rawMidi_withBusName = pApplet.getClass().getMethod("rawMidi", byte[].class, String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.eventMethod_midiMessage_withBusName = pApplet.getClass().getMethod("midiMessage", MidiMessage.class, String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bus_name = string;
        this.in_devices = new Vector();
        this.in_receivers = new Vector();
        this.in_transmitters = new Vector();
        this.out_devices = new Vector();
        this.out_receivers = new Vector();
        this.raw_listeners = new Vector();
        this.simple_listeners = new Vector();
        this.standard_listeners = new Vector();
        if (n != -1) {
            this.addInput(n);
        }
        if (n2 != -1) {
            this.addOutput(n2);
        }
    }

    public boolean addInput(int n) {
        if (n != -1) {
            MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
            if (n >= infoArray.length || n < 0) {
                System.err.println("\nWarning: The chosen input device numbered [" + n + "] was not added because it doesn't exist");
                return false;
            }
            try {
                MidiDevice midiDevice = MidiSystem.getMidiDevice(infoArray[n]);
                if (midiDevice.getMaxTransmitters() == 0) {
                    System.err.println("\nWarning: The chosen input device [" + n + "] \"" + infoArray[n].getName() + "\" was not added because it is output only");
                    return false;
                }
                for (MidiDevice autoCloseable2 : this.in_devices) {
                    if (midiDevice.getDeviceInfo() != autoCloseable2.getDeviceInfo()) continue;
                    return true;
                }
                midiDevice.open();
                MReceiver mReceiver = new MReceiver();
                Transmitter transmitter = midiDevice.getTransmitter();
                transmitter.setReceiver(mReceiver);
                this.in_transmitters.add(transmitter);
                this.in_receivers.add(mReceiver);
                this.in_devices.add(midiDevice);
                return true;
            }
            catch (MidiUnavailableException midiUnavailableException) {
                System.err.println("\nWarning: The chosen input device [" + n + "] \"" + infoArray[n].getName() + "\" was not added because a MidiUnavailableException was thrown");
                return false;
            }
        }
        return false;
    }

    public boolean addInput(String string) {
        return this.addInput(this.inputDeviceNameToNumber(string));
    }

    public boolean addOutput(int n) {
        if (n != -1) {
            MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
            if (n >= infoArray.length || n < 0) {
                System.err.println("\nWarning: The chosen output device numbered [" + n + "] was not added because it doesn't exist");
                return false;
            }
            try {
                MidiDevice midiDevice = MidiSystem.getMidiDevice(infoArray[n]);
                if (midiDevice.getMaxReceivers() == 0) {
                    System.err.println("\nWarning: The chosen output device [" + n + "] \"" + infoArray[n].getName() + "\" was not added because it is input only");
                    return false;
                }
                for (MidiDevice midiDevice2 : this.out_devices) {
                    if (midiDevice.getDeviceInfo() != midiDevice2.getDeviceInfo()) continue;
                    return true;
                }
                midiDevice.open();
                this.out_receivers.add(midiDevice.getReceiver());
                this.out_devices.add(midiDevice);
                return true;
            }
            catch (MidiUnavailableException midiUnavailableException) {
                System.err.println("\nWarning: The chosen output device [" + n + "] \"" + infoArray[n].getName() + "\" was not added because a MidiUnavailableException was thrown");
                return false;
            }
        }
        return false;
    }

    public boolean addOutput(String string) {
        return this.addOutput(this.outputDeviceNameToNumber(string));
    }

    public void clearInputs() {
        for (Transmitter autoCloseable : this.in_transmitters) {
            autoCloseable.close();
        }
        for (MidiDevice midiDevice : this.in_devices) {
            try {
                midiDevice.close();
            }
            catch (Exception exception) {
                System.err.println("\nWarning: Mystery error during clearInputs()");
            }
        }
        this.in_transmitters.clear();
        this.in_receivers.clear();
        this.in_devices.clear();
    }

    public void clearOutputs() {
        for (Receiver autoCloseable : this.out_receivers) {
            autoCloseable.close();
        }
        for (MidiDevice midiDevice : this.out_devices) {
            try {
                midiDevice.close();
            }
            catch (Exception exception) {
                System.err.println("\nWarning: Mystery error during clearOutputs()");
            }
        }
        this.out_receivers.clear();
        this.out_devices.clear();
    }

    public void clearAll() {
        this.clearInputs();
        this.clearOutputs();
    }

    public void sendMessage(int n) {
        ShortMessage shortMessage = new ShortMessage();
        try {
            shortMessage.setMessage(n);
            for (Receiver receiver : this.out_receivers) {
                receiver.send(shortMessage, -1L);
            }
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            System.err.println("\nWarning: Message not sent, InvalidMidiDataException thrown");
        }
    }

    public void sendMessage(int n, int n2, int n3) {
        ShortMessage shortMessage = new ShortMessage();
        try {
            shortMessage.setMessage(n, n2, n3);
            for (Receiver receiver : this.out_receivers) {
                receiver.send(shortMessage, -1L);
            }
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            System.err.println("\nWarning: Message not sent, InvalidMidiDataException thrown");
        }
    }

    public void sendMessage(int n, int n2, int n3, int n4) {
        ShortMessage shortMessage = new ShortMessage();
        try {
            shortMessage.setMessage(n, n2, n3, n4);
            for (Receiver receiver : this.out_receivers) {
                receiver.send(shortMessage, -1L);
            }
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            System.err.println("\nWarning: Message not sent, InvalidMidiDataException thrown");
        }
    }

    public void sendNoteOn(int n, int n2, int n3) {
        ShortMessage shortMessage = new ShortMessage();
        try {
            shortMessage.setMessage(144, this.constrain(n, 0, 15), this.constrain(n2, 0, 127), this.constrain(n3, 0, 127));
            for (Receiver receiver : this.out_receivers) {
                receiver.send(shortMessage, -1L);
            }
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            System.err.println("\nWarning: Message not sent, InvalidMidiDataException thrown");
        }
    }

    public void sendNoteOff(int n, int n2, int n3) {
        ShortMessage shortMessage = new ShortMessage();
        try {
            shortMessage.setMessage(128, this.constrain(n, 0, 15), this.constrain(n2, 0, 127), this.constrain(n3, 0, 127));
            for (Receiver receiver : this.out_receivers) {
                receiver.send(shortMessage, -1L);
            }
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            System.err.println("\nWarning: Message not sent, InvalidMidiDataException thrown");
        }
    }

    public void sendControllerChange(int n, int n2, int n3) {
        ShortMessage shortMessage = new ShortMessage();
        try {
            shortMessage.setMessage(176, this.constrain(n, 0, 15), this.constrain(n2, 0, 127), this.constrain(n3, 0, 127));
            for (Receiver receiver : this.out_receivers) {
                receiver.send(shortMessage, -1L);
            }
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            System.err.println("\nWarning: Message not sent, InvalidMidiDataException thrown");
        }
    }

    void notifyListeners(MidiMessage midiMessage) {
        byte[] byArray = midiMessage.getMessage();
        for (RawMidiListener midiListener : this.raw_listeners) {
            midiListener.rawMidiMessage(byArray);
        }
        if ((byArray[0] & 0xF0) == 144) {
            for (SimpleMidiListener simpleMidiListener : this.simple_listeners) {
                simpleMidiListener.noteOn(byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF);
            }
        } else if ((byArray[0] & 0xF0) == 128) {
            for (SimpleMidiListener simpleMidiListener : this.simple_listeners) {
                simpleMidiListener.noteOff(byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF);
            }
        } else if ((byArray[0] & 0xF0) == 176) {
            for (SimpleMidiListener simpleMidiListener : this.simple_listeners) {
                simpleMidiListener.controllerChange(byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF);
            }
        }
        for (StandardMidiListener standardMidiListener : this.standard_listeners) {
            standardMidiListener.midiMessage(midiMessage);
        }
    }

    void notifyPApplet(MidiMessage midiMessage) {
        byte[] byArray = midiMessage.getMessage();
        if ((byArray[0] & 0xF0) == 144) {
            if (this.eventMethod_noteOn != null) {
                try {
                    this.eventMethod_noteOn.invoke((Object)this.parent, byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF);
                }
                catch (Exception exception) {
                    System.err.println("\nDisabling noteOn() because an unkown exception was thrown");
                    exception.printStackTrace();
                    this.eventMethod_noteOn = null;
                }
            }
            if (this.eventMethod_noteOn_withBusName != null) {
                try {
                    this.eventMethod_noteOn_withBusName.invoke((Object)this.parent, byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF, this.bus_name);
                }
                catch (Exception exception) {
                    System.err.println("\nDisabling noteOn() with bus_name because an unkown exception was thrown");
                    exception.printStackTrace();
                    this.eventMethod_noteOn_withBusName = null;
                }
            }
        } else if ((byArray[0] & 0xF0) == 128) {
            if (this.eventMethod_noteOff != null) {
                try {
                    this.eventMethod_noteOff.invoke((Object)this.parent, byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF);
                }
                catch (Exception exception) {
                    System.err.println("\nDisabling noteOff() because an unkown exception was thrown");
                    exception.printStackTrace();
                    this.eventMethod_noteOff = null;
                }
            }
            if (this.eventMethod_noteOff_withBusName != null) {
                try {
                    this.eventMethod_noteOff_withBusName.invoke((Object)this.parent, byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF, this.bus_name);
                }
                catch (Exception exception) {
                    System.err.println("\nDisabling noteOff() with bus_name because an unkown exception was thrown");
                    exception.printStackTrace();
                    this.eventMethod_noteOff_withBusName = null;
                }
            }
        } else if ((byArray[0] & 0xF0) == 176) {
            if (this.eventMethod_controllerChange != null) {
                try {
                    this.eventMethod_controllerChange.invoke((Object)this.parent, byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF);
                }
                catch (Exception exception) {
                    System.err.println("\nDisabling controllerChange() because an unkown exception was thrown");
                    exception.printStackTrace();
                    this.eventMethod_controllerChange = null;
                }
            }
            if (this.eventMethod_controllerChange_withBusName != null) {
                try {
                    this.eventMethod_controllerChange_withBusName.invoke((Object)this.parent, byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF, this.bus_name);
                }
                catch (Exception exception) {
                    System.err.println("\nDisabling controllerChange() with bus_name because an unkown exception was thrown");
                    exception.printStackTrace();
                    this.eventMethod_controllerChange_withBusName = null;
                }
            }
        }
        if (this.eventMethod_rawMidi != null) {
            try {
                this.eventMethod_rawMidi.invoke((Object)this.parent, new Object[]{byArray});
            }
            catch (Exception exception) {
                System.err.println("\nDisabling rawMidi() because an unkown exception was thrown");
                exception.printStackTrace();
                this.eventMethod_rawMidi = null;
            }
        }
        if (this.eventMethod_rawMidi_withBusName != null) {
            try {
                this.eventMethod_rawMidi_withBusName.invoke((Object)this.parent, byArray, this.bus_name);
            }
            catch (Exception exception) {
                System.err.println("\nDisabling rawMidi() with bus_name because an unkown exception was thrown");
                exception.printStackTrace();
                this.eventMethod_rawMidi_withBusName = null;
            }
        }
        if (this.eventMethod_midiMessage != null) {
            try {
                this.eventMethod_midiMessage.invoke((Object)this.parent, midiMessage);
            }
            catch (Exception exception) {
                System.err.println("\nDisabling midiMessage() because an unkown exception was thrown");
                exception.printStackTrace();
                this.eventMethod_midiMessage = null;
            }
        }
        if (this.eventMethod_midiMessage_withBusName != null) {
            try {
                this.eventMethod_midiMessage_withBusName.invoke((Object)this.parent, midiMessage);
            }
            catch (Exception exception) {
                System.err.println("\nDisabling midiMessage() with bus_name because an unkown exception was thrown");
                exception.printStackTrace();
                this.eventMethod_midiMessage_withBusName = null;
            }
        }
    }

    public void addMidiListener(MidiListener midiListener) {
        for (MidiListener midiListener2 : this.listeners) {
            if (midiListener2 != midiListener) continue;
            return;
        }
        this.listeners.add(midiListener);
        if (midiListener instanceof RawMidiListener) {
            this.raw_listeners.add((RawMidiListener)midiListener);
        }
        if (midiListener instanceof SimpleMidiListener) {
            this.simple_listeners.add((SimpleMidiListener)midiListener);
        }
        if (midiListener instanceof StandardMidiListener) {
            this.standard_listeners.add((StandardMidiListener)midiListener);
        }
    }

    int constrain(int n, int n2, int n3) {
        if (n > n3) {
            n = n3;
        }
        if (n < n2) {
            n = n2;
        }
        return n;
    }

    public String getBusName() {
        return this.bus_name;
    }

    public void setBusName(String string) {
        this.bus_name = string;
    }

    int inputDeviceNameToNumber(String string) {
        if (!string.equals("")) {
            MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
            for (int i = 0; i < infoArray.length; ++i) {
                try {
                    if (!infoArray[i].getName().equals(string) || MidiSystem.getMidiDevice(infoArray[i]).getMaxReceivers() != 0) continue;
                    return i;
                }
                catch (MidiUnavailableException midiUnavailableException) {
                    System.err.println("\nWarning: device [" + i + "] \"" + infoArray[i].getName() + "\" could not be gotten during inputDeviceNameToNumber(), MidiUnavailableException thrown");
                }
            }
            System.err.println("Warning: No input MIDI devices named: \"" + string + "\" were found");
        }
        return -1;
    }

    int outputDeviceNameToNumber(String string) {
        if (!string.equals("")) {
            MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
            for (int i = 0; i < infoArray.length; ++i) {
                try {
                    if (!infoArray[i].getName().equals(string) || MidiSystem.getMidiDevice(infoArray[i]).getMaxTransmitters() != 0) continue;
                    return i;
                }
                catch (MidiUnavailableException midiUnavailableException) {
                    System.err.println("\nWarning: device [" + i + "] \"" + infoArray[i].getName() + "\" could not be gotten during outputDeviceNameToNumber(), MidiUnavailableException thrown");
                }
            }
            System.err.println("Warning: No output MIDI devices named: \"" + string + "\" were found");
        }
        return -1;
    }

    public String toString() {
        String string = "MidiBus: \"," + this.bus_name + "\" ";
        string = string + this.in_devices.size() + " input devices, ";
        string = string + this.out_devices.size() + " outputdevices, ";
        string = string + this.listeners.size() + " listeners, ";
        return string;
    }

    public boolean equals(MidiBus midiBus) {
        if (this.getBusName() != midiBus.getBusName()) {
            return false;
        }
        if (this.in_devices != midiBus.in_devices) {
            return false;
        }
        if (this.out_devices != midiBus.out_devices) {
            return false;
        }
        return this.listeners == midiBus.listeners;
    }

    public MidiBus clone() {
        MidiBus midiBus = new MidiBus(this.parent, -1, -1, this.bus_name);
        for (MidiDevice object : this.in_devices) {
        }
        for (MidiDevice midiDevice : this.out_devices) {
        }
        for (MidiListener midiListener : this.listeners) {
            midiBus.addMidiListener(midiListener);
        }
        return midiBus;
    }

    public int hashCode() {
        return this.bus_name.hashCode() + this.in_devices.hashCode() + this.out_devices.hashCode() + this.listeners.hashCode();
    }

    protected void finalize() {
        this.close();
        this.parent.unregisterDispose((Object)this);
    }

    public void close() {
        this.clearAll();
    }

    public void stop() {
        this.close();
    }

    public void dispose() {
        this.close();
    }

    public static void list() {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        System.out.println("\nAvailable Midi Devices:");
        System.out.println("-----------------------");
        for (int i = 0; i < infoArray.length; ++i) {
            try {
                MidiDevice midiDevice = MidiSystem.getMidiDevice(infoArray[i]);
                if (midiDevice.getMaxReceivers() == 0) {
                    System.out.println("[" + i + "] \"" + infoArray[i].getName() + "\" [Input]");
                    continue;
                }
                if (midiDevice.getMaxTransmitters() == 0) {
                    System.out.println("[" + i + "] \"" + infoArray[i].getName() + "\" [Output]");
                    continue;
                }
                System.out.println("[" + i + "] \"" + infoArray[i].getName() + "\" [Input/Output]");
                continue;
            }
            catch (MidiUnavailableException midiUnavailableException) {
                System.err.println("\nWarning: device [" + i + "] \"" + infoArray[i].getName() + "\" could not be gotten during list(), MidiUnavailableException thrown");
            }
        }
    }

    public static String[][] returnList() {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        String[][] stringArray = new String[infoArray.length][2];
        for (int i = 0; i < infoArray.length; ++i) {
            try {
                stringArray[i][0] = infoArray[i].getName();
                MidiDevice midiDevice = MidiSystem.getMidiDevice(infoArray[i]);
                if (midiDevice.getMaxReceivers() == 0) {
                    stringArray[i][1] = "Input";
                    continue;
                }
                if (midiDevice.getMaxTransmitters() == 0) {
                    stringArray[i][1] = "Output";
                    continue;
                }
                stringArray[i][1] = "Input/Output";
                continue;
            }
            catch (MidiUnavailableException midiUnavailableException) {
                System.err.println("\nWarning: device [" + i + "] \"" + infoArray[i].getName() + "\" could not be gotten during returnList(), MidiUnavailableException thrown");
            }
        }
        return stringArray;
    }

    private class MReceiver
    implements Receiver {
        MReceiver() {
        }

        public void close() {
            MidiBus.this.out_receivers.remove(this);
        }

        public void send(MidiMessage midiMessage, long l) {
            if (midiMessage.getStatus() == 144 && midiMessage.getMessage()[2] == 0) {
                try {
                    ShortMessage shortMessage = (ShortMessage)midiMessage;
                    shortMessage.setMessage(128, shortMessage.getData1(), shortMessage.getData2());
                    midiMessage = shortMessage;
                }
                catch (Exception exception) {
                    System.err.println("\nWarning: Mystery error during noteOn (0 velocity) to noteOff conversion");
                }
            }
            MidiBus.this.notifyListeners(midiMessage);
            MidiBus.this.notifyPApplet(midiMessage);
        }
    }
}

