/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.serial.Serial;
import themidibus.MidiBus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Serial_MIDI_Converter_V2
extends PApplet {
    MidiBus myBus;
    Serial port;
    String[] ports;
    String[][] midiport;
    String StatusText;
    String MainTextLineOne;
    String MainTextLineTwo;
    String MainTextLineThree;
    int[] val;
    int[] buffer;
    int state;
    int SPortCount;
    int SerialPortID;
    int MPortCount;
    int i;
    int channel;
    int midistatus;
    int pitch;
    int velocity;
    int midi_inputPORT;
    int midi_outputPORT;
    float RX_flash;
    int RX_flashcolor;
    int TX_flashcolor;
    float TX_flash;
    int line_space;
    int number;
    int value;
    boolean SerPortFlag;
    boolean RX_ERROR_FLAG;
    int flashcolor;
    int flashOFFcolor;

    public void setup() {
        this.size(380, 440);
        this.textFont(this.createFont("Arial", 12.0f));
        this.frameRate(25.0f);
        this.background(255);
    }

    public void draw() {
        switch (this.state) {
            case 0: {
                if ((float)this.millis() - this.RX_flash > 50.0f) {
                    this.RX_flashcolor = this.flashOFFcolor;
                }
                this.fill(this.RX_flashcolor);
                this.noStroke();
                this.rect(this.width - 30, this.height - 34, 8.0f, 8.0f);
                this.TX_activity(false);
                break;
            }
            case 1: {
                this.updatedisplay();
                this.selectSerialport();
                break;
            }
            case 2: {
                this.updatedisplay();
                this.selectMidi_IN_port();
                break;
            }
            case 3: {
                this.updatedisplay();
                this.selectMidi_OUT_port();
                break;
            }
        }
    }

    public void TX_activity(boolean bl) {
        if (bl) {
            this.TX_flashcolor = this.flashcolor;
            this.TX_flash = this.millis();
        } else if ((float)this.millis() - this.TX_flash > 100.0f) {
            this.TX_flashcolor = this.flashOFFcolor;
        }
        this.fill(this.TX_flashcolor);
        this.noStroke();
        this.rect(this.width - 30, this.height - 21, 8.0f, 8.0f);
    }

    public void serialEvent(Serial serial) {
        int n = 0;
        n = 0;
        while (n < 3) {
            int n2;
            this.val[n] = n2 = serial.read();
            if (n == 0 && n2 < 128) {
                n = 3;
            }
            ++n;
        }
        if (this.val[0] >= 128) {
            this.myBus.sendMessage(this.val[0], this.val[1], this.val[2]);
            this.RX_flashcolor = this.flashcolor;
        } else {
            this.RX_flashcolor = this.color(255, 0, 0);
        }
        this.RX_flash = this.millis();
    }

    public void noteOn(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 144;
        n4 = n5 | n;
        this.TX_activity(true);
        this.port.write(n4);
        this.port.write(n2);
        this.port.write(n3);
    }

    public void noteOff(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 128;
        n4 = n5 | n;
        this.TX_activity(true);
        this.port.write(n4);
        this.port.write(n2);
        this.port.write(n3);
    }

    public void controllerChange(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 128;
        n4 = n5 | n;
        this.TX_activity(true);
        this.port.write(n4);
        this.port.write(n2);
        this.port.write(n3);
    }

    public void selectSerialport() {
        this.StatusText = "Press the number key that matches your Arduino's serial Port:";
        this.SPortCount = Serial.list().length;
        if (this.SPortCount == 0) {
            this.StatusText = "ERROR: No serial Ports avaliable";
        } else {
            this.fill(0);
            this.i = 0;
            while (this.i < Serial.list().length) {
                this.text("Port [" + this.i + "] :    " + this.ports[this.i], 15.0f, 80 + this.i * 25, 600.0f, 350.0f);
                ++this.i;
            }
        }
    }

    public void selectMidi_IN_port() {
        this.StatusText = "Press the number key that matches MIDI INPUT Port:";
        this.MPortCount = this.midiport.length;
        if (this.MPortCount == 0) {
            this.StatusText = "ERROR: No MIDI Ports avaliable";
        } else {
            this.fill(0);
            this.line_space = 0;
            this.i = 0;
            while (this.i < this.midiport.length) {
                if (this.midiport[this.i][1] == "Input" || this.midiport[this.i][1] == "Input/Output") {
                    this.text("MIDI Port [" + this.i + "] :    " + this.midiport[this.i][0] + " - " + this.midiport[this.i][1], 15.0f, 80 + this.line_space, 600.0f, 350.0f);
                    this.line_space += 25;
                }
                ++this.i;
            }
        }
    }

    public void selectMidi_OUT_port() {
        this.StatusText = "Press the number key that matches MIDI OUTPUT Port:";
        this.MPortCount = this.midiport.length;
        if (this.MPortCount == 0) {
            this.StatusText = "ERROR: No MIDI Ports avaliable";
        } else {
            this.fill(0);
            this.line_space = 0;
            this.i = 0;
            while (this.i < this.midiport.length) {
                if (this.midiport[this.i][1] == "Output" || this.midiport[this.i][1] == "Input/Output") {
                    this.text("MIDI Port [" + this.i + "] :    " + this.midiport[this.i][0] + " - " + this.midiport[this.i][1], 15.0f, 80 + this.line_space, 600.0f, 350.0f);
                    this.line_space += 25;
                }
                ++this.i;
            }
        }
    }

    public void updatedisplay() {
        this.background(255);
        int n = 220;
        int n2 = 0;
        while (n2 < 60) {
            this.stroke(0.0f, n, 255.0f);
            this.line(0.0f, n2, this.width, n2);
            n -= 2;
            ++n2;
        }
        n = 128;
        n2 = this.height - 40;
        while (n2 < this.height) {
            this.stroke(0.0f, n, 255.0f);
            this.line(0.0f, n2, this.width, n2);
            n += 3;
            ++n2;
        }
        n = 50;
        n2 = this.height - 60;
        while (n2 < this.height - 40) {
            this.stroke(0.0f, n, 255.0f);
            this.line(0.0f, n2, this.width, n2);
            n += 3;
            ++n2;
        }
        this.fill(255);
        this.stroke(0);
        this.text("Status:", 15.0f, this.height - 45);
        this.fill(0);
        this.stroke(50);
        this.text(this.StatusText, 15.0f, this.height - 25, 600.0f, 350.0f);
        if (this.state == 0) {
            this.text(this.MainTextLineOne, 15.0f, 100.0f);
            this.text(this.MainTextLineTwo, 15.0f, 120.0f);
            this.text(this.MainTextLineThree, 15.0f, 140.0f);
            this.text("Serial RX", this.width - 85, this.height - 25);
            this.text("Serial TX", this.width - 85, this.height - 12);
            this.rect(this.width - 30, this.height - 34, 8.0f, 8.0f);
            this.rect(this.width - 30, this.height - 21, 8.0f, 8.0f);
        }
        this.textAlign(3);
        this.fill(255);
        this.textSize(18.0f);
        this.text("Serial <> MIDI Converter", this.width / 2 - 150, 10.0f, 300.0f, 20.0f);
        this.textSize(12.0f);
        this.text("By Mark Demers - SpikenzieLabs.com", this.width / 2 - 150, 35.0f, 300.0f, 45.0f);
        this.textAlign(37);
        this.textSize(12.0f);
    }

    public void keyPressed() {
        switch (this.state) {
            case 0: {
                break;
            }
            case 1: {
                if (this.key - 48 > Serial.list().length - 1) break;
                this.state = 2;
                this.StatusText = "You are using serial port [" + (this.key - 48) + "] : " + this.ports[this.key - 48];
                this.SerialPortID = this.key - 48;
                this.MainTextLineOne = "Serial port [" + (this.key - 48) + "] : " + this.ports[this.key - 48];
                break;
            }
            case 2: {
                if (this.key - 48 > this.midiport.length - 1) break;
                this.state = 3;
                this.StatusText = "You are using Mini INPUT port [" + (this.key - 48) + "] : " + this.midiport[this.key - 48][0];
                this.midi_inputPORT = this.key - 48;
                this.MainTextLineTwo = "Midi INPUT port [" + (this.key - 48) + "] : " + this.midiport[this.key - 48][0];
                this.delay(250);
                break;
            }
            case 3: {
                if (this.key - 48 <= this.midiport.length - 1) {
                    this.state = 0;
                    this.StatusText = "Converter is running";
                    this.midi_outputPORT = this.key - 48;
                    this.myBus = new MidiBus((PApplet)this, this.midi_inputPORT, this.midi_outputPORT);
                    this.MainTextLineThree = "Midi OUTPUT port [" + (this.key - 48) + "] : " + this.midiport[this.key - 48][0];
                    this.port = new Serial((PApplet)this, this.ports[this.SerialPortID], 57600);
                    this.port.buffer(3);
                    this.port.clear();
                }
                this.updatedisplay();
                break;
            }
        }
    }

    public void stop() {
        this.port.stop();
        this.myBus.close();
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"Serial_MIDI_Converter_V2"});
    }

    private final /* synthetic */ void this() {
        this.ports = Serial.list();
        Serial_MIDI_Converter_V2 serial_MIDI_Converter_V2 = this;
        this.midiport = serial_MIDI_Converter_V2.myBus.returnList();
        this.StatusText = "";
        this.MainTextLineOne = "";
        this.MainTextLineTwo = "";
        this.MainTextLineThree = "";
        this.val = new int[3];
        this.buffer = new int[16];
        this.state = 1;
        this.SPortCount = 0;
        this.SerialPortID = 0;
        this.MPortCount = 0;
        this.i = 0;
        this.channel = 0;
        this.midistatus = 128;
        this.pitch = 64;
        this.velocity = 127;
        this.midi_inputPORT = 0;
        this.midi_outputPORT = 0;
        this.RX_flash = 0.0f;
        this.RX_flashcolor = 0;
        this.TX_flashcolor = 0;
        this.TX_flash = 0.0f;
        this.line_space = 0;
        this.number = 0;
        this.value = 90;
        this.SerPortFlag = false;
        this.RX_ERROR_FLAG = false;
        this.flashcolor = this.color(0, 255, 0);
        this.flashOFFcolor = this.color(204, 204, 204);
    }

    public Serial_MIDI_Converter_V2() {
        this.this();
    }
}

