/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.serial.Serial;
import themidibus.MidiBus;

public class Serial_MIDI_Converter_V2D
extends PApplet {
    MidiBus myBus;
    Serial port;
    String[] ports = Serial.list();
    String[] midiInputs = MidiBus.availableInputs();
    String StatusText = "";
    String MainTextLineOne = "";
    String MainTextLineTwo = "";
    String MainTextLineThree = "";
    String MainTextLineFour = "";
    String[] available_outputs = MidiBus.availableOutputs();
    String[] available_inputs = MidiBus.availableInputs();
    String Letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    String LettersLower = "abcdefghijklmnopqrstuvwxyz";
    int[] Bauds = new int[]{9600, 19200, 31250, 38400, 57600, 115200};
    int[] val = new int[3];
    int[] buffer = new int[16];
    int state = 1;
    int SPortCount = 0;
    int SerialPortID = 0;
    int SerialPortBaudRate = 0;
    int MPortCount = 0;
    int i = 0;
    int channel = 0;
    int midistatus = 128;
    int pitch = 64;
    int velocity = 127;
    int midi_inputPORT = 0;
    int midi_outputPORT = 0;
    float RX_flash = 0.0f;
    int RX_flashcolor = 0;
    int TX_flashcolor = 0;
    float TX_flash = 0.0f;
    int line_space = 0;
    int lineSpacing = 15;
    int number = 0;
    int value = 90;
    int keyselection = 99;
    boolean SerPortFlag = false;
    boolean RX_ERROR_FLAG = false;
    int flashcolor = this.color(0, 255, 0);
    int flashOFFcolor = this.color(204, 204, 204);

    public void setup() {
        this.size(380, 440);
        this.textFont(this.createFont("Arial", 12.0f));
        this.frameRate(25.0f);
        this.background(255);
    }

    public void draw() {
        switch (this.state) {
            case 0: {
                if ((float)this.millis() - this.RX_flash > 50.0f) {
                    this.RX_flashcolor = this.flashOFFcolor;
                }
                this.fill(this.RX_flashcolor);
                this.noStroke();
                this.rect(this.width - 30, this.height - 34, 8.0f, 8.0f);
                this.TX_activity(false);
                break;
            }
            case 1: {
                this.updatedisplay();
                this.selectSerialport();
                break;
            }
            case 2: {
                this.updatedisplay();
                this.selectSerialBoadRate();
                break;
            }
            case 3: {
                this.updatedisplay();
                this.selectMidi_IN_port();
                break;
            }
            case 4: {
                this.updatedisplay();
                this.selectMidi_OUT_port();
            }
        }
    }

    public void TX_activity(boolean bl) {
        if (bl) {
            this.TX_flashcolor = this.flashcolor;
            this.TX_flash = this.millis();
        } else if ((float)this.millis() - this.TX_flash > 100.0f) {
            this.TX_flashcolor = this.flashOFFcolor;
        }
        this.fill(this.TX_flashcolor);
        this.noStroke();
        this.rect(this.width - 30, this.height - 21, 8.0f, 8.0f);
    }

    public void serialEvent(Serial serial) {
        int n = 0;
        n = 0;
        while (n < 3) {
            int n2;
            this.val[n] = n2 = serial.read();
            if (n == 0 && n2 < 128) {
                n = 3;
            }
            ++n;
        }
        if (this.val[0] >= 128) {
            this.myBus.sendMessage(this.val[0], this.val[1], this.val[2]);
            this.RX_flashcolor = this.flashcolor;
        } else {
            this.RX_flashcolor = this.color(255, 0, 0);
        }
        this.RX_flash = this.millis();
    }

    public void noteOn(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 144;
        n4 = n5 | n;
        this.TX_activity(true);
        this.port.write(n4);
        this.port.write(n2);
        this.port.write(n3);
    }

    public void noteOff(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 128;
        n4 = n5 | n;
        this.TX_activity(true);
        this.port.write(n4);
        this.port.write(n2);
        this.port.write(n3);
    }

    public void controllerChange(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 176;
        n4 = n5 | n;
        this.TX_activity(true);
        this.port.write(n4);
        this.port.write(n2);
        this.port.write(n3);
    }

    public void selectSerialport() {
        this.StatusText = "Press the number key that matches your Arduino's serial Port:";
        this.SPortCount = Serial.list().length;
        if (this.SPortCount == 0) {
            this.StatusText = "ERROR: No serial Ports avaliable";
        } else {
            this.fill(0);
            this.line_space = 0;
            this.i = 0;
            while (this.i < Serial.list().length) {
                this.text("Port [" + this.Letters.charAt(this.i) + "] :    " + this.ports[this.i], 15.0f, 80 + this.line_space, 600.0f, 350.0f);
                this.line_space += this.lineSpacing;
                ++this.i;
            }
        }
    }

    public void selectSerialBoadRate() {
        this.StatusText = "Press the letter key that matches your serial port baud rate:";
        this.fill(0);
        this.line_space = 0;
        this.i = 0;
        while (this.i < 6) {
            this.text("Baud rate [" + this.Letters.charAt(this.i) + "] :    " + this.Bauds[this.i] + " bps ", 15.0f, 80 + this.line_space, 600.0f, 350.0f);
            this.line_space += this.lineSpacing;
            ++this.i;
        }
    }

    public void selectMidi_IN_port() {
        this.StatusText = "Press the number key that matches MIDI INPUT Port:";
        this.MPortCount = this.available_inputs.length;
        if (this.MPortCount == 0) {
            this.StatusText = "ERROR: No MIDI Ports avaliable";
        } else {
            this.fill(0);
            this.line_space = 0;
            this.i = 0;
            while (this.i < this.available_inputs.length) {
                this.text("MIDI Port [" + this.Letters.charAt(this.i) + "] :    " + this.available_inputs[this.i], 15.0f, 80 + this.line_space, 600.0f, 350.0f);
                this.line_space += this.lineSpacing;
                ++this.i;
            }
        }
    }

    public void selectMidi_OUT_port() {
        this.StatusText = "Press the number key that matches MIDI OUTPUT Port:";
        this.MPortCount = this.available_outputs.length;
        if (this.MPortCount == 0) {
            this.StatusText = "ERROR: No MIDI Ports avaliable";
        } else {
            this.fill(0);
            this.line_space = 0;
            this.i = 0;
            while (this.i < this.available_outputs.length) {
                this.text("MIDI Port [" + this.Letters.charAt(this.i) + "] :    " + this.available_outputs[this.i], 15.0f, 80 + this.line_space, 600.0f, 350.0f);
                this.line_space += this.lineSpacing;
                ++this.i;
            }
        }
    }

    public void updatedisplay() {
        this.background(255);
        int n = 220;
        int n2 = 0;
        while (n2 < 60) {
            this.stroke(0.0f, n, 255.0f);
            this.line(0.0f, n2, this.width, n2);
            n -= 2;
            ++n2;
        }
        n = 128;
        n2 = this.height - 40;
        while (n2 < this.height) {
            this.stroke(0.0f, n, 255.0f);
            this.line(0.0f, n2, this.width, n2);
            n += 3;
            ++n2;
        }
        n = 50;
        n2 = this.height - 60;
        while (n2 < this.height - 40) {
            this.stroke(0.0f, n, 255.0f);
            this.line(0.0f, n2, this.width, n2);
            n += 3;
            ++n2;
        }
        this.fill(255);
        this.stroke(0);
        this.text("Status:", 15.0f, this.height - 45);
        this.fill(0);
        this.stroke(50);
        this.text(this.StatusText, 15.0f, this.height - 25, 600.0f, 350.0f);
        if (this.state == 0) {
            this.text(this.MainTextLineOne, 15.0f, 100.0f);
            this.text(this.MainTextLineTwo, 15.0f, 120.0f);
            this.text(this.MainTextLineThree, 15.0f, 140.0f);
            this.text(this.MainTextLineFour, 15.0f, 160.0f);
            this.text("Serial RX", this.width - 85, this.height - 25);
            this.text("Serial TX", this.width - 85, this.height - 12);
            this.rect(this.width - 30, this.height - 34, 8.0f, 8.0f);
            this.rect(this.width - 30, this.height - 21, 8.0f, 8.0f);
        }
        this.textAlign(3);
        this.fill(255);
        this.textSize(12.0f);
        this.text("Serial <> MIDI Converter", this.width / 2 - 150, 10.0f, 300.0f, 20.0f);
        this.textSize(12.0f);
        this.text("By Mark Demers - SpikenzieLabs.com", this.width / 2 - 150, 35.0f, 300.0f, 45.0f);
        this.textAlign(37);
        this.textSize(12.0f);
    }

    public void keyPressed() {
        this.decodeLetter();
        if (this.keyselection != 99 || this.keyselection != -1) {
            switch (this.state) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.keyselection > Serial.list().length - 1) break;
                    this.state = 2;
                    this.StatusText = "You are using serial port [" + this.keyselection + "] : " + this.ports[this.keyselection];
                    this.SerialPortID = this.keyselection;
                    this.MainTextLineOne = "Serial port [" + this.keyselection + "] : " + this.ports[this.keyselection];
                    break;
                }
                case 2: {
                    if (this.keyselection > 5) break;
                    this.state = 3;
                    this.SerialPortBaudRate = this.keyselection;
                    this.MainTextLineTwo = "Serial Baud Rate [" + this.keyselection + "] : " + this.Bauds[this.keyselection] + " bps ";
                    break;
                }
                case 3: {
                    if (this.keyselection > this.available_inputs.length - 1) break;
                    this.state = 4;
                    this.StatusText = "You are using MIDI INPUT port [" + this.keyselection + "] : " + this.available_inputs[this.keyselection];
                    this.midi_inputPORT = this.keyselection;
                    this.MainTextLineThree = "MIDI Input port [" + this.keyselection + "] : " + this.available_inputs[this.keyselection];
                    this.delay(250);
                    break;
                }
                case 4: {
                    if (this.keyselection <= this.available_outputs.length - 1) {
                        this.state = 0;
                        this.StatusText = "Converter is running";
                        this.midi_outputPORT = this.keyselection;
                        this.myBus = new MidiBus((PApplet)this, this.midi_inputPORT, this.midi_outputPORT);
                        this.MainTextLineFour = "MIDI Output port [" + this.keyselection + "] : " + this.available_outputs[this.keyselection];
                        this.port = new Serial((PApplet)this, this.ports[this.SerialPortID], this.Bauds[this.SerialPortBaudRate]);
                        this.port.buffer(3);
                        this.port.clear();
                    }
                    this.updatedisplay();
                }
            }
        }
    }

    public void decodeLetter() {
        this.keyselection = 99;
        if (this.key > '@' && this.key < '[') {
            this.keyselection = this.Letters.indexOf(this.key);
        } else if (this.key > '`' && this.key < '{') {
            this.keyselection = this.LettersLower.indexOf(this.key);
        }
    }

    public void stop() {
        this.port.stop();
        this.myBus.close();
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#c0c0c0", "Serial_MIDI_Converter_V2D"});
    }
}

